<?php

namespace Controller;

use Inc\Helper;
use Model\Query;

class PageAuth extends Page {
  /**
   * Before a page is served
   * @param $f3
   * @param $params
   */
  public function beforeroute($f3, $params) {
    parent::beforeroute($f3, $params);

    $user = $this->user();
    // not logged in
    if (!$user) {
      // capture current URI, so user can be redirected automatically upon logging in
      $f3->reroute('@login?destination=' . urlencode(Helper::uri()));
    }
  }

  public function favorites($f3, $params) {
    $query = new Query();
    $this->view->data['coins'] = $query->coins(
      'market_cap',
      'DESC',
      99999,
      0,
      FALSE,
      TRUE
    );
  }
}