<?php

namespace Controller;

class UserSetting extends Base {
  const DAYS365 = 31536000;
  /**
   * Handle settings change (e.g. current display currency)
   * @param $f3
   * @param $params
   */
  public function change($f3, $params) {
    $currency = $f3->get('POST.currency');
    $language = $f3->get('POST.language');

    // store selected currency in cookies
    if ($currency)
      setcookie('currency', $currency, time() + self::DAYS365);

    // store selected language in cookies
    if ($language)
      setcookie('language', $language, time() + self::DAYS365);

    $f3->reroute($f3->get('POST.path'));
  }
}