<?php

namespace Inc;

class Email {
  private $status;

  public function __construct($emailTo, $emailSubject, $emailTemplate) {
    $f3 = \Base::instance();
    $emailFrom = $f3->get('SITE.EMAIL');
    $emailBody = \Template::instance()->render($emailTemplate);

    if (($smtpHost = $f3->get('SMTP.HOST')) && ($smtpPort = $f3->get('SMTP.PORT')) && ($smtpUser = $f3->get('SMTP.USER')) && ($smtpPassword = $f3->get('SMTP.PASSWORD'))) {
      $emailProtocol = 'SMTP';
      $this->smtpEmail($smtpHost, $smtpPort, $f3->get('SMTP.ENCRYPTION'), $smtpUser, $smtpPassword, $emailFrom, $emailTo, $emailSubject, $emailBody);
    } else {
      $emailProtocol = 'SYSTEM';
      $this->systemEmail($emailFrom, $emailTo, $emailSubject, $emailBody);
    }

    Logger::log(sprintf('%s email from %s to %s %s', $emailProtocol, $emailFrom, $emailTo, $this->status ? 'SENT' : 'FAILED'));
    return $this;
  }

  public function status() {
    return $this->status;
  }

  /**
   * Send an email using SMTP
   *
   * @param $smtpHost
   * @param $smtpPort
   * @param $smtpUser
   * @param $smtpPassword
   * @param $emailFrom
   * @param $emailTo
   * @param $emailSubject
   * @param $emailBody
   */
  private function smtpEmail($smtpHost, $smtpPort, $smtpEncryption, $smtpUser, $smtpPassword, $emailFrom, $emailTo, $emailSubject, $emailBody) {
    $smtp = new \SMTP(
      $smtpHost,
      $smtpPort,
      $smtpEncryption,
      $smtpUser,
      $smtpPassword
    );

    $smtp->set('Content-type', 'text/html; charset=UTF-8');
    $smtp->set('From', $emailFrom);
    $smtp->set('To', $emailTo);
    $smtp->set('Subject', $emailSubject);
    $this->status = $smtp->send($emailBody);

    if (!$this->status) {
      Logger::log('smtpEmail: error');
      Logger::log($smtp->log());
    }

    return $this;
  }

  /**
   * Send an email using system mail function
   *
   * @param $emailFrom
   * @param $emailTo
   * @param $emailSubject
   * @param $emailBody
   * @return $this
   */
  private function systemEmail($emailFrom, $emailTo, $emailSubject, $emailBody) {
    $emailHeaders = "From: " . $emailFrom . "\r\n";
    $emailHeaders .= "MIME-Version: 1.0\r\n";
    $emailHeaders .= "Content-Type: text/html; charset=UTF-8\r\n";
    $this->status = @mail($emailTo, $emailSubject, $emailBody, $emailHeaders);
    if (!$this->status) {
      Logger::log('systemEmail: error');
      Logger::log(error_get_last());
    }

    return $this;
  }
}