<?php

namespace Inc;

use Intervention\Image\ImageManager;

/**
 * Class Image - image manipulations
 * @package Inc
 */
class Image {
  private $manager;
  private $image;

  /**
   * Image constructor.
   * @param $image - can be a raw image string or path to image file
   */
  public function __construct($image) {
    if (Helper::finfoEnabled()) {
      if (Helper::imagickEnabled()) {
        $this->manager = new ImageManager(['driver' => 'imagick']);
      } elseif (Helper::gdEnabled()) {
        $this->manager = new ImageManager(['driver' => 'gd']);
      }
    }

    if ($this->manager) {
      try {
        $this->image = $this->manager->make($image);
      } catch (\Exception $e) {
        Logger::log(sprintf('Can not create image file: %s', $e->getMessage()), 2);
      }
    }
    return $this;
  }

  /**
   * Save image
   * @param $imagePath
   * @param $width
   * @param $height
   * @return $this
   */
  public function save($imagePath) {
    $result = FALSE;
    if ($this->image) {
      try {
        $this->image->save($imagePath);
        $result = TRUE;
      } catch (\Exception $e) {
        Logger::log(sprintf('Can not save image file: %s', $e->getMessage()), 2);
      }
    }
    return $result;
  }

  /**
   * Create an image thumb
   *
   * @param $thumbPath
   * @param $width
   * @param $height
   * @return $this
   */
  public function thumb($thumbPath, $width, $height) {
    $result = FALSE;
    if ($this->image) {
      try {
        $this->image
          ->resize($width, $height, function ($constraint) {
            $constraint->aspectRatio();
          })
          ->save($thumbPath);
        $result = TRUE;
      } catch (\Exception $e) {
        Logger::log(sprintf('Can not create thumb: %s', $e->getMessage()), 2);
        return FALSE;
      }
    }
    return $result;
  }
}