<?php
$config = parse_ini_file('config/framework.ini', TRUE);

return [
  'paths' => [
      'migrations' => 'db/migrations',
      'seeds' => 'db/seeds'
    ],
    'environments' => [
      'default_migration_table' => 'phinxlog',
      'default_database' => 'db',
      'db' => [
        'adapter'   => 'mysql',
        'host'      => isset($config['DB']['HOST']) ? $config['DB']['HOST'] : '',
        'port'      => isset($config['DB']['PORT']) ? $config['DB']['PORT'] : '',
        'name'      => isset($config['DB']['DATABASE']) ? $config['DB']['DATABASE'] : '',
        'user'      => isset($config['DB']['USER']) ? $config['DB']['USER'] : '',
        'pass'      => isset($config['DB']['PASSWORD']) ? str_replace('"','',$config['DB']['PASSWORD']) : '',
        'charset'   => 'utf8',
        'collation' => 'utf8_unicode_ci'
      ]
    ]
  ];
?>