<?php

namespace Inc;

use Inc\Logger;
use Phinx\Console\PhinxApplication;
use Phinx\Wrapper\TextWrapper;

class Phinx {
  private $wrapper;

  public function __construct() {
    $this->wrapper = $this->phinxWrapper();
  }

  public function migrate() {
    Logger::log('Running migrations');
    $output = $this->wrapper->getMigrate();
    Logger::log($output);
  }

  public function rollback() {
    Logger::log('Running migrations');
    $output = $this->wrapper->getRollback(NULL, 0);
    Logger::log($output);
  }

  public function seedCoin($useNewWrapper = FALSE) {
    Logger::log('Running CoinSeeder');
    $wrapper = $useNewWrapper ? $this->phinxWrapper() : $this->wrapper;
    $output = $wrapper->getSeed(NULL, NULL, 'CoinSeeder');
    Logger::log($output);
  }

  public function seedCurrency($useNewWrapper = FALSE) {
    Logger::log('Running CurrencySeeder');
    $wrapper = $useNewWrapper ? $this->phinxWrapper() : $this->wrapper;
    $output = $wrapper->getSeed(NULL, NULL, 'CurrencySeeder');
    Logger::log($output);
  }

  /**
   * Get phinx wrapper
   * IMPORTANT: if using the same phinxApp and wrapper on multiple seeds it will throw Symfony\Component\Console\Exception\RuntimeException: Unable to write output.
   * @return \Phinx\Wrapper\TextWrapper
   */
  private function phinxWrapper() {
    $phinxApp = new PhinxApplication();
    $phinxTextWrapper = new TextWrapper($phinxApp);
    $phinxTextWrapper->setOption('configuration', 'app/inc/phinx-config.php');
    $phinxTextWrapper->setOption('parser', 'php');
    $phinxTextWrapper->setOption('environment', 'db');
    return $phinxTextWrapper;
  }
}