<?php

namespace Model;
use Inc\Database;

/**
 * Class BaseSingleton - to be used for singletone models to avoid querying the same data multiple times
 * @package Model
 */
class BaseSingleton extends \Prefab {
  protected $f3;
  protected $db;

  // using protected constructor for singleton, so it can't be instantiated like a normal class
  protected function __construct() {
    $this->f3 = \Base::instance();
    $this->db = Database::instance();
    return $this;
  }
}