<?php

namespace Model;
use Inc\Logger;
use Inc\Helper;

/**
 * Class Query - generic model to retrieve data for multiple entities or from multiple data tables
 * @package Model
 */
class Query extends Base {

	/**
	 * Get all coins
	 *
	 * @param $sortOrder
	 * @param $sortDirection
	 * @param $limit
	 * @param int $offset
	 * @param bool|FALSE $featured
	 * @param bool|FALSE $favorite
	 * @return mixed
	 */
	public function coins($sortOrder, $sortDirection, $limit, $offset = 0, $featured = FALSE, $favorite = FALSE) {
		
		global $f3;
		$link_type=$f3->get('SITE.COIN_PAGE_KEY');
		// lcn,lcs,ucs
		
		$currencyRate = CurrencyRate::instance();
		$displayCurrencyRate = $currencyRate->rate();

		$extraClauses = '';
		if ($featured)
			$extraClauses .= ' AND featured = 1';

		if ($favorite)
			$extraClauses .= ' AND id IN (SELECT coin_id FROM favorite_coin WHERE user_id =' . $this->f3->get('USER')['id'] . ')';

		if (!in_array($sortOrder, ['name','price','change','change_pct','open','low','high','supply','volume','volume_ccy','total_volume','total_volume_ccy','market_cap','last_updated']))
			$sortOrder = $this->f3->get('SITE.COINS_SORT');
		if (!in_array($sortDirection, ['ASC','DESC']))
			$sortDirection = $this->f3->get('SITE.COINS_DIR');

		$result = $this->db->exec('SELECT id, symbol, name, price, `change`, change_pct, volume, volume_ccy, total_volume, total_volume_ccy, supply,
																	open, low, high, market_cap, last_updated, COALESCE(logo, "_NOLOGO.png") AS logo, intraday_quotes, featured, ws_disabled
																FROM coin
																WHERE last_updated IS NOT NULL AND active = 1' . $extraClauses . ' ORDER BY `'.$sortOrder.'` '.$sortDirection.' LIMIT '.$limit.' OFFSET '.$offset);
		// iterating through rows and apply custom changes
		foreach ($result as &$row) {
			array_walk($row, function(&$value, $key) use ($displayCurrencyRate) {
				if (in_array($key, ['price','market_cap'])) {
					$value *= $displayCurrencyRate;
				} elseif ($key == 'intraday_quotes' && $value) {
					$value = json_decode($value, JSON_OBJECT_AS_ARRAY);
					$value['p'] = array_map(function($quote) use ($displayCurrencyRate) {
						return $quote * $displayCurrencyRate;
					}, $value['p']);
				}
			});
			$row['coin_page_key'] = Helper::coinPageKey($row);
		}

		return $result;
	}

	public function coinsListSearch($page = 1, $search = '') {
		$limit = intval($this->f3->get('SITE.COINS_LIMIT'));
		return $this->db->exec('SELECT id, symbol, name, price, supply, market_cap, last_updated, COALESCE(logo, "_NOLOGO.png") AS logo, active, featured
															FROM coin
															WHERE symbol LIKE :symbol OR UPPER(name) LIKE :name
															ORDER BY market_cap DESC LIMIT '.$limit.' OFFSET '.$limit*($page-1),
			[':symbol' => '%'.strtoupper($search).'%', ':name' => '%'.strtoupper($search).'%']);
	}

	public function coinsList() {
		return $this->db->exec('SELECT symbol, name FROM coin');
	}
	
	public function coinsListFull($where = "") {
		$where_r=["1"];
		$where_r[]=$where;
		$where=array_filter($where_r);
		$where=implode(" and ",$where);
		return $this->db->exec('SELECT symbol, name, featured, active FROM coin WHERE ' . $where);
	}

	/**
	 * Get overall coins stats to display in the website header
	 * @return array
	 */
	public function stats() {
		$currencyRate = CurrencyRate::instance();
		$displayCurrencyRate = $currencyRate->rate();

		$result = $this->db->exec('SELECT count(symbol) AS total_coins, sum(total_volume_ccy) AS total_volume, sum(market_cap) AS total_market_cap FROM coin WHERE active = 1')[0];
		return [
			'total_coins' => $result['total_coins'],
			'total_volume' => $result['total_volume'] * $displayCurrencyRate,
			'total_market_cap' => $result['total_market_cap'] * $displayCurrencyRate,
		];
	}

	/**
	 * Get top risers
	 * @return mixed
	 */
	public function risers() {
		global $f3;
		$link_type=$f3->get('SITE.COIN_PAGE_KEY');
		$rows = $this->db->exec('SELECT symbol, name, change_pct FROM coin WHERE active = 1 AND change_pct IS NOT NULL ORDER BY change_pct DESC LIMIT 5');
		if(!is_array($rows))$rows=[];
		foreach ($rows as &$row) {
			$row['coin_page_key'] = Helper::coinPageKey($row);
		}
		return $rows;
	}

	/**
	 * Get top fallers
	 * @return mixed
	 */
	public function fallers() {
		global $f3;
		$link_type=$f3->get('SITE.COIN_PAGE_KEY');
		$rows = $this->db->exec('SELECT symbol, name, ABS(change_pct) AS change_pct FROM coin WHERE active = 1 AND change_pct IS NOT NULL ORDER BY -change_pct DESC LIMIT 5');
		if(!is_array($rows))$rows=[];
		foreach ($rows as &$row) {
			$row['coin_page_key'] = Helper::coinPageKey($row);
		}
		return $rows;
	}

	/**
	 * Get list of all coin symbols comma separated
	 * @return mixed
	 */
	public function symbols() {
		$this->db->exec('SET SESSION group_concat_max_len = 30000');
		return $this->db->exec('SELECT GROUP_CONCAT(symbol) AS list FROM coin WHERE active = 1')[0]['list'];
	}


	/**
	 * Search coins
	 * @param $search
	 * @return mixed
	 */
	public function search($search) {
		$search = strtoupper($search);
		$rows = $this->db->exec(
			'SELECT symbol AS id, symbol, name, COALESCE(logo, "_NOLOGO.png") AS logo FROM coin WHERE active = 1 AND (symbol like :s1 OR UPPER(name) LIKE :s2) LIMIT 20',
			[':s1' => $search.'%', ':s2' => '%'.$search.'%']
		);
		
		if(is_array($rows))
			foreach ($rows as &$row) {
				$row['id'] = Helper::coinPageKey($row);
			}
		
		return $rows;
	}

	public function countCoins($search = '') {
		if ($search) {
			return $this->db->exec(
				'SELECT COUNT(*) AS cnt FROM coin WHERE symbol LIKE :symbol OR UPPER(name) LIKE :name',
				[':symbol' => '%'.strtoupper($search).'%', ':name' => '%'.strtoupper($search).'%']
			)[0]['cnt'];
		} else {
			return $this->db->exec('SELECT COUNT(*) AS cnt FROM coin')[0]['cnt'];
		}
	}

	public function countCurrencies() {
		return $this->db->exec('SELECT COUNT(*) AS cnt FROM currency')[0]['cnt'];
	}

	public function coinsCurrenciesQuotes() {
		return $this->db->exec('SELECT symbol, name, price AS quote, "cryptocurrency" AS type FROM coin WHERE active = 1 AND price > 0
															UNION ALL
														SELECT symbol, name, rate, "currency" FROM currency WHERE rate > 0');
	}

	/**
	 * Get list of coins with donation addresses
	 *
	 * @return array
	 */
	public function donationCoins() {
		$result = [];
		$donationParts = $this->f3->get('SITE.DONATION_ADDRESSES');

		if (!empty($donationParts)) {
			foreach ($donationParts as $donationPart) {
				if (strpos($donationPart, ':') !== FALSE) {
					list ($symbol, $address) = explode(':', $donationPart);
					$result[$symbol] = ['address' => $address];
				}
			}

			$symbols = array_keys($result);
			if (!empty($symbols)) {
				foreach ($this->db->exec('SELECT symbol, name, COALESCE(logo, "_NOLOGO.png") AS logo FROM coin WHERE symbol IN ("' . implode('","',$symbols) . '")') as $coin) {
					$result[$coin['symbol']]['name'] = $coin['name'];
					$result[$coin['symbol']]['logo'] = $coin['logo'];
				}
			}
		}

		return $result;
	}
}