<!--Main content-->
<section id="content" class="container">
	<!--Settings-->
	<section>
		<div class="row">
			<div class="col s12">
				<h1 class="primary-text">
					{{ @text.settings }}
				</h1>
				<div class="divider"></div>
			</div>
		</div>
		<form action="{{ @BASE }}{{ 'backend_settings' | alias }}" method="POST" enctype="multipart/form-data">
			<ul class="collapsible" data-collapsible="accordion">
				<li>
					<div class="collapsible-header"><i class="material-icons">settings</i>{{ @text.main_settings }}</div>
					<div class="collapsible-body">
						<div class="row">
							<div class="input-field col s12 m8 l6 xl4">
								<select name="globals#LANGUAGE" class="materialize-select">
									<repeat group="{{ @vars.languages }}" key="{{ @code }}" value="{{ @item }}">
										<option value="{{ @code }}" {{ @LANG == @code ? 'selected' : '' }}>{{ @item }} ({{ @code }})</option>
									</repeat>
								</select>
								<label>{{ @text.language }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12 m8 l6 xl4">
								<select name="SITE#COLOR" class="materialize-select">
									<repeat group="{{ @vars.colors }}" value="{{ @item }}">
										<option value="{{ @item }}" {{ @SITE.COLOR == @item ? 'selected' : '' }}>{{ ucfirst(@item) }}</option>
									</repeat>
								</select>
								<label>{{ @text.color }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12 m8 l6 xl4">
								<select name="SITE#CURRENCY" class="materialize-select">
									<repeat group="{{ @vars.currencies_list }}" key="{{ @key }}" value="{{ @item }}">
										<option value="{{ @key }}" {{ @SITE.CURRENCY == @key ? 'selected' : '' }}>{{ @item.name }}</option>
									</repeat>
								</select>
								<label>{{ @text.currency }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12 m8 l6 xl4">
								<select name="SITE#THOUSANDS_SEPARATOR" class="materialize-select">
									<repeat group="{{ @vars.delimiters }}" key="{{ @key }}" value="{{ @item }}">
										<option value="{{ @key }}" {{ @SITE.THOUSANDS_SEPARATOR == @key ? 'selected' : '' }}>{{ @item }}</option>
									</repeat>
								</select>
								<label>{{ @text.thousands_separator }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12 m8 l6 xl4">
								<select name="SITE#DECIMAL_POINT" class="materialize-select">
									<repeat group="{{ @vars.delimiters }}" key="{{ @key }}" value="{{ @item }}">
										<option value="{{ @key }}" {{ @SITE.DECIMAL_POINT == @key ? 'selected' : '' }}>{{ @item }}</option>
									</repeat>
								</select>
								<label>{{ @text.decimal_point }}</label>
							</div>
						</div>
						<div class="row">
							<div class="col s12">
								<check if="{{ @SITE.REQUIRE_COOKIE_ACCEPTANCE }}">
									<input type="hidden" name="SITE#REQUIRE_COOKIE_ACCEPTANCE" value="0" />
								</check>
								<input id="scrollbar_enabled" type="checkbox" name="SITE#REQUIRE_COOKIE_ACCEPTANCE" {{ @SITE.REQUIRE_COOKIE_ACCEPTANCE ? 'checked="checked"' : '' }} />
								<label for="scrollbar_enabled">{{ @text.require_cookie_acceptance }}</label>
							</div>
						</div>
						<div class="row">
							<div class="col s12">
								<check if="{{ @SITE.COINS_REALTIME_FEED }}">
									<input type="hidden" name="SITE#COINS_REALTIME_FEED" value="0" />
								</check>
								<input id="coins_realtime_feed" type="checkbox" name="SITE#COINS_REALTIME_FEED" {{ @SITE.COINS_REALTIME_FEED ? 'checked="checked"' : '' }} />
								<label for="coins_realtime_feed">{{ @text.coins_realtime_feed }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12">
								<select name="SITE#COIN_PAGE_KEY" class="materialize-select">
									<repeat group="['ucs','lcs','lcn']" value="{{ @item }}">
										<option value="{{ @item }}" {{ @item == @SITE.COIN_PAGE_KEY ? 'selected' : '' }}>{{ @text['coin_page_keys'][@item] }}</option>
									</repeat>
								</select>
								<label>{{ @text.coin_page_key }}</label>
							</div>
						</div>
						<check if="{{ file_exists('assets/images/logo-udf.png') }}">
							<div class="row">
								<div class="input-field col s12 m8 l6 xl4">
									{{ @text.s_uploaded_logo }}<br>
									<img src="assets/images/logo-udf.png" width="100px">
								</div>
							</div>
							<div class="row">
								<div class="col s12">
									<input id="site_logo_udf_remove" type="checkbox" name="site_logo_udf_remove" />
									<label for="site_logo_udf_remove">{{ @text.s_uploaded_logo_remove }}</label>
								</div>
								<br>
							</div>
						</check>	
						<div class="file-field input-field col s12">
							<div class="btn">
								<span>File</span>
								<input name="site_logo_udf" type="file" multiple>
							</div>
							<div class="file-path-wrapper">
								<input class="file-path validate" type="text" placeholder="{{ @text.s_upload_logo }}">
							</div>
						</div>
					</div>
				</li>
				<li>
					<div class="collapsible-header"><i class="material-icons">view_list</i>{{ @text.front_page_settings }}</div>
					<div class="collapsible-body">
						<div class="row">
							<div class="input-field col s12">
								<input type="hidden" name="SITE#COINS_FIELDS" value="" />
								<select id="coins-fields" name="SITE#COINS_FIELDS[]" multiple="multiple" class="materialize-select">
									<option value="" disabled>{{ @text.displayed_fields }}</option>
									<repeat group="['price','change','change_pct','open','low','high','supply','volume','volume_ccy','total_volume','total_volume_ccy','market_cap','intraday_quotes','last_updated']" value="{{ @item }}">
										<option value="{{ @item }}" {{ in_array(@item, (array)@SITE.COINS_FIELDS) ? 'selected' : '' }}>{{ @text[@item] }}</option>
									</repeat>
								</select>
								<label>{{ @text.displayed_fields }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12 m8 l6 xl4">
								<select name="SITE#COINS_SORT" class="materialize-select">
									<repeat group="{{ @text.sort_column_options }}" key="{{ @key }}" value="{{ @item }}">
										<option value="{{ @key }}" {{ @SITE.COINS_SORT == @key ? 'selected' : '' }}>{{ @item }}</option>
									</repeat>
								</select>
								<label>{{ @text.sort_column }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12 m8 l6 xl4">
								<select name="SITE#COINS_DIR" class="materialize-select">
									<repeat group="{{ @text.sort_order_options }}" key="{{ @key }}" value="{{ @item }}">
										<option value="{{ @key }}" {{ @SITE.COINS_DIR == @key ? 'selected' : '' }}>{{ @item }}</option>
									</repeat>
								</select>
								<label>{{ @text.sort_order }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12">
								<input id="coins_number" type="text" name="SITE#COINS_LIMIT" value="{{ @SITE.COINS_LIMIT }}">
								<label for="coins_number">{{ @text.coins_number }}</label>
							</div>
						</div>
					</div>
				</li>
				<li>
					<div class="collapsible-header"><i class="material-icons">show_chart</i>{{ @text.coin_page_settings }}</div>
					<div class="collapsible-body">
						<div class="row">
							<div class="input-field col s12">
								<select name="CHART#TYPE_COIN" class="materialize-select">
									<repeat group="['line','smoothedLine','column','step','candlestick']" value="{{ @item }}">
										<option value="{{ @item }}" {{ @item == @CHART.TYPE_COIN ? 'selected' : '' }}>{{ @text['chart_'.@item] }}</option>
									</repeat>
								</select>
								<label>{{ @text.chart_type_coin }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12">
								<select name="CHART#TYPE_VOLUME" class="materialize-select">
									<repeat group="['line','smoothedLine','column','step']" value="{{ @item }}">
										<option value="{{ @item }}" {{ @item == @CHART.TYPE_VOLUME ? 'selected' : '' }}>{{ @text['chart_'.@item] }}</option>
									</repeat>
								</select>
								<label>{{ @text.chart_type_volume }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12">
								<select name="CHART#PERIODS[]" multiple="multiple" class="materialize-select">
									<repeat group="['1d','1w','2w','1m','3m','6m','ytd','1y','2y','5y','all']" value="{{ @item }}">
										<option value="{{ @item }}" {{ in_array(@item, @CHART.PERIODS) ? 'selected' : '' }}>{{ @text[@item] }}</option>
									</repeat>
								</select>
								<label>{{ @text.chart_periods }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12">
								<select name="CHART#DEFAULT_PERIOD" class="materialize-select">
									<repeat group="['1d','1w','2w','1m','3m','6m','ytd','1y','2y','5y','all']" value="{{ @item }}">
										<option value="{{ @item }}" {{ @item == @CHART.DEFAULT_PERIOD ? 'selected' : '' }}>{{ @text[@item] }}</option>
									</repeat>
								</select>
								<label>{{ @text.chart_period_default }}</label>
							</div>
						</div>
						<div class="row">
							<div class="col s12">
								<check if="{{ @CHART.SHORT_NUMBER_FORMAT }}">
									<input type="hidden" name="CHART#SHORT_NUMBER_FORMAT" value="0" />
								</check>
								<input id="short_number_format" type="checkbox" name="CHART#SHORT_NUMBER_FORMAT" {{ @CHART.SHORT_NUMBER_FORMAT ? 'checked="checked"' : '' }} />
								<label for="short_number_format" class="tooltip" data-position="bottom" data-delay="50" data-tooltip="{{ @text.chart_short_number_format_tooltip }}">{{ @text.chart_short_number_format }}</label>
							</div>
						</div>
						<div class="row">
							<div class="col s12">
								<check if="{{ @CHART.SCROLLBAR_ENABLED }}">
									<input type="hidden" name="CHART#SCROLLBAR_ENABLED" value="0" />
								</check>
								<input id="scrollbar_enabled" type="checkbox" name="CHART#SCROLLBAR_ENABLED" {{ @CHART.SCROLLBAR_ENABLED ? 'checked="checked"' : '' }} />
								<label for="scrollbar_enabled">{{ @text.chart_scrollbar_enabled }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12">
								<input type="hidden" name="SITE#COIN_TABS" value="" />
								<select name="SITE#COIN_TABS[]" multiple="multiple" class="materialize-select">
									<option value="" disabled>{{ @text.coin_enabled_tabs }}</option>
									<repeat group="['info','key_indicators','trades','social','historical_data','widget']" value="{{ @item }}">
										<option value="{{ @item }}" {{ in_array(@item, (array)@SITE.COIN_TABS) ? 'selected' : '' }}>{{ @text[@item] }}</option>
									</repeat>
								</select>
								<label>{{ @text.coin_enabled_tabs }}</label>
							</div>
						</div>
					</div>
				</li>
				<li>
					<div class="collapsible-header"><i class="material-icons">trending_up</i>{{ @text.risers_fallers_page_settings }}</div>
					<div class="collapsible-body">
						<div class="row">
							<div class="input-field col s12">
								<input type="hidden" name="SITE#RISERS_FALLERS_FIELDS" value="" />
								<select id="risers-fallers-fields" name="SITE#RISERS_FALLERS_FIELDS[]" multiple="multiple" class="materialize-select">
									<option value="" disabled>{{ @text.displayed_fields }}</option>
									<repeat group="['price','change','change_pct','open','low','high','supply','volume','volume_ccy','total_volume','total_volume_ccy','market_cap','intraday_quotes','last_updated']" value="{{ @item }}">
										<option value="{{ @item }}" {{ in_array(@item, (array)@SITE.RISERS_FALLERS_FIELDS) ? 'selected' : '' }}>{{ @text[@item] }}</option>
									</repeat>
								</select>
								<label>{{ @text.displayed_fields }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12">
								<input id="risers_limit" type="text" name="SITE#RISERS_LIMIT" value="{{ @SITE.RISERS_LIMIT }}">
								<label for="risers_limit">{{ @text.risers_limit }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12">
								<input id="fallers_limit" type="text" name="SITE#FALLERS_LIMIT" value="{{ @SITE.FALLERS_LIMIT }}">
								<label for="fallers_limit">{{ @text.fallers_limit }}</label>
							</div>
						</div>
					</div>
				</li>
				<li>
					<div class="collapsible-header"><i class="material-icons">star_border</i>{{ @text.favorites_page_settings }}</div>
					<div class="collapsible-body">
						<div class="row">
							<div class="input-field col s12">
								<input type="hidden" name="SITE#FAVORITES_FIELDS" value="" />
								<select id="risers-fallers-fields" name="SITE#FAVORITES_FIELDS[]" multiple="multiple" class="materialize-select">
									<option value="" disabled>{{ @text.displayed_fields }}</option>
									<repeat group="['price','change','change_pct','open','low','high','supply','volume','volume_ccy','total_volume','total_volume_ccy','market_cap','intraday_quotes','last_updated']" value="{{ @item }}">
										<option value="{{ @item }}" {{ in_array(@item, (array)@SITE.FAVORITES_FIELDS) ? 'selected' : '' }}>{{ @text[@item] }}</option>
									</repeat>
								</select>
								<label>{{ @text.displayed_fields }}</label>
							</div>
						</div>
					</div>
				</li>
				<li>
					<div class="collapsible-header"><i class="material-icons">rss_feed</i>{{ @text.news_feed_settings }}</div>
					<div class="collapsible-body">
						<div class="row">
							<div class="input-field col s12">
								<input id="rss_url" type="text" name="SITE#RSS_URL" value="{{ @SITE.RSS_URL }}">
								<label for="rss_url">{{ @text.rss_url }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12">
								<input id="rss_speed" type="text" name="SITE#RSS_SPEED" value="{{ @SITE.RSS_SPEED }}">
								<label for="rss_speed">{{ @text.rss_speed }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12">
								<input id="rss_delay" type="text" name="SITE#RSS_DELAY" value="{{ @SITE.RSS_DELAY }}">
								<label for="rss_delay">{{ @text.rss_delay }}</label>
							</div>
						</div>
					</div>
				</li>
				<li>
					<div class="collapsible-header"><i class="material-icons">mail_outline</i>{{ @text.email_settings }}</div>
					<div class="collapsible-body">
						<div class="row">
							<div class="input-field col s12">
								<input id="email" type="text" name="SITE#EMAIL" value="{{ @SITE.EMAIL }}" class="tooltip" data-position="bottom" data-delay="50" data-tooltip="{{ @text.email_tooltip }}">
								<label for="email">{{ @text.email_from }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12">
								<input id="email" type="text" name="SMTP#HOST" value="{{ @SMTP.HOST }}" class="tooltip" data-position="bottom" data-delay="50" data-tooltip="{{ @text.smtp_host_tooltip }}">
								<label for="email">{{ @text.smtp_host }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12">
								<input id="email" type="text" name="SMTP#PORT" value="{{ @SMTP.PORT }}" class="tooltip" data-position="bottom" data-delay="50" data-tooltip="{{ @text.smtp_port_tooltip }}">
								<label for="email">{{ @text.smtp_port }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12">
								<select id="encryption" name="SMTP#ENCRYPTION" class="materialize-select">
									<option value="">{{ @text.none }}</option>
									<option value="SSL" {{ @SMTP.ENCRYPTION=='SSL' ? 'selected' : '' }}>{{ @text.ssl }}</option>
									<option value="TLS" {{ @SMTP.ENCRYPTION=='TLS' ? 'selected' : '' }}>{{ @text.tls }}</option>
								</select>
								<label for="encryption">{{ @text.encryption }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12">
								<input id="email" type="text" name="SMTP#USER" value="{{ @SMTP.USER }}" class="tooltip" data-position="bottom" data-delay="50" data-tooltip="{{ @text.smtp_user_tooltip }}">
								<label for="email">{{ @text.smtp_user }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12">
								<input id="email" type="text" name="SMTP#PASSWORD" value="{{ @SMTP.PASSWORD }}" class="tooltip" data-position="bottom" data-delay="50" data-tooltip="{{ @text.smtp_password_tooltip }}">
								<label for="email">{{ @text.smtp_password }}</label>
							</div>
						</div>
					</div>
				</li>
				<li>
					<div class="collapsible-header"><i class="material-icons">attach_money</i>{{ @text.monetization }}</div>
					<div class="collapsible-body">
						<div class="row">
							<div class="input-field col s12">
								<input id="adsense_client_id" placeholder="ca-pub-12345678910" type="text" name="ADSENSE#CLIENT_ID" value="{{ @ADSENSE.CLIENT_ID }}">
								<label for="adsense_client_id">{{ @text.adsense_client_id }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12">
								<input id="adsense_slot_id1" placeholder="9999999999" type="text" name="ADSENSE#SLOT_ID1" value="{{ @ADSENSE.SLOT_ID1 }}">
								<label for="adsense_slot_id1">{{ @text.adsense_slot_id1 }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12">
								<input id="adsense_slot_id1" placeholder="9999999999" type="text" name="ADSENSE#SLOT_ID2" value="{{ @ADSENSE.SLOT_ID2 }}">
								<label for="adsense_slot_id1">{{ @text.adsense_slot_id1 }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12">
								<input id="buy_link" placeholder="" class="tooltip" type="text" name="SITE#COIN_BUY_LINK" value="{{ @SITE.COIN_BUY_LINK }}" data-tooltip="{{ @text.buy_link_tooltip }}">
								<label for="buy_link">{{ @text.buy_link }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12">
								<input id="sell_link" placeholder="" class="tooltip" type="text" name="SITE#COIN_SELL_LINK" value="{{ @SITE.COIN_SELL_LINK }}" data-tooltip="{{ @text.sell_link_tooltip }}">
								<label for="sell_link">{{ @text.sell_link }}</label>
							</div>
						</div>
						<div class="row">
							<div class="input-field col s12">
								<input id="donation-coins" placeholder="BTC:1JbRERXDnK7M1LSRkb6RbBbDaie78T9MnC" class="tooltip" type="text" name="SITE#DONATION_ADDRESSES" value="{{ implode(',', (array)@SITE.DONATION_ADDRESSES) }}" data-tooltip="{{ @text.donation_addresses_tooltip }}">
								<label for="donation-coins">{{ @text.donation_addresses }}</label>
							</div>
						</div>
					</div>
				</li>
				<li>
					<div class="collapsible-header"><i class="material-icons">exposure_plus_1</i>{{ @text.tracking_settings }}</div>
					<div class="collapsible-body">
						<div class="row">
							<div class="input-field col s12">
								<input placeholder="UA-43555555-1" id="google_tracking_id" type="text" name="ANALYTICS#GOOGLE" value="{{ @ANALYTICS.GOOGLE }}">
								<label for="google_tracking_id">{{ @text.google_tracking_id }}</label>
							</div>
						</div>
					</div>
				</li>
				<li>
					<div class="collapsible-header"><i class="material-icons">file_download</i>{{ @text.api_settings }}</div>
					<div class="collapsible-body">
						<div class="row">
							<check if="{{ !@API.CRYPTOCOMPARE_API_KEY }}">
								<div class="col s12">
									<div class="card-panel orange lighten-1">
										<p class="white-text">
											{{ @text.cryptocompare_api_key_hint }}
										</p>
										<a class="waves-effect waves-light btn" href="https://min-api.cryptocompare.com" target="_blank">{{ @text.sign_up }}</a>
									</div>
								</div>
							</check>
							<div class="input-field col s12">
								<input id="cryptocompare_api_key" type="text" name="API#CRYPTOCOMPARE_API_KEY" value="{{ @API.CRYPTOCOMPARE_API_KEY }}">
								<label for="cryptocompare_api_key">{{ @text.cryptocompare_api_key }}</label>
							</div>
						</div>
						<div class="row">
							<check if="{{ !@API.OPENEXCHANGERATES_APP_ID }}">
								<div class="col s12">
									<div class="card-panel orange lighten-1">
										<p class="white-text">
											{{ @text.openexchangerates_app_id_hint }}
										</p>
										<a class="waves-effect waves-light btn" href="https://openexchangerates.org/signup/free" target="_blank">{{ @text.sign_up }}</a>
									</div>
								</div>
							</check>
							<div class="input-field col s12">
								<input id="openexchangerates_app_id" type="text" name="API#OPENEXCHANGERATES_APP_ID" value="{{ @API.OPENEXCHANGERATES_APP_ID }}">
								<label for="openexchangerates_app_id">{{ @text.openexchangerates_app_id }}</label>
							</div>
						</div>
						<div class="row">
							<check if="{{ !@SOCIAL.FACEBOOK_APP_ID }}">
								<div class="col s12">
									<div class="card-panel orange lighten-1">
										<p class="white-text">
											{{ @text.facebook_app_id_hint }}
										</p>
										<a class="waves-effect waves-light btn" href="https://developers.facebook.com/docs/apps/register/" target="_blank">{{ @text.read_more }}</a>
									</div>
								</div>
							</check>
							<div class="input-field col s12">
								<input placeholder="" id="facebook_app_id" type="text" name="SOCIAL#FACEBOOK_APP_ID" value="{{ @SOCIAL.FACEBOOK_APP_ID ? sprintf('%.0f',@SOCIAL.FACEBOOK_APP_ID) : '' }}">
								<label for="facebook_app_id">{{ @text.facebook_app_id }}</label>
							</div>
						</div>
					</div>
				</li>
				<li>
					<div class="collapsible-header"><i class="material-icons">security</i>{{ @text.security_settings }}</div>
					<div class="collapsible-body">
						<div class="row">
							<div class="input-field col s12 m8 l6 xl4">
								<select name="SECURITY#LOGIN_PERIOD" class="materialize-select">
									<repeat group="{{ @text.login_period_options }}" key="{{ @key }}" value="{{ @item }}">
										<option value="{{ @key }}" {{ @SECURITY.LOGIN_PERIOD == @key ? 'selected' : '' }}>{{ @item }}</option>
									</repeat>
								</select>
								<label>{{ @text.login_period }}</label>
							</div>
						</div>
					</div>
				</li>
				<li>
					<div class="collapsible-header"><i class="material-icons">code</i>{{ @text.developer_settings }}</div>
					<div class="collapsible-body">
						<div class="row">
							<div class="input-field col s12 m8 l6 xl4">
								<select name="globals#DEBUG" class="materialize-select">
									<repeat group="{{ [0,1,2,3] }}" value="{{ @item }}">
										<option value="{{ @item }}" {{ @DEBUG == @item ? 'selected' : '' }}>{{ @item }}</option>
									</repeat>
								</select>
								<label>{{ @text.log_level }}</label>
							</div>
						</div>
					</div>
				</li>
			</ul>
			<div class="row">
				<div class="col s12">
					<button class="waves-effect waves-light btn-large" type="submit">{{ @text.save }}</button>
				</div>
			</div>
		</form>
	</section>
	<!--END Settings-->
</section>