<!--Main content-->
<section id="content" class="container">
  <!--Strings-->
  <section>
    <div class="row">
      <div class="col s12">
        <h1 class="primary-text">
          {{ @text.strings_overrides }}
        </h1>
        <div class="divider"></div>
      </div>
    </div>
    <div class="row">
      <div class="col s12 m8 l6 xl4">
        <form action="{{ @BASE }}{{ @PATH }}" method="GET">
          <select id="strings-language" name="language" class="materialize-select">
            <repeat group="{{ @vars.languages }}" key="{{ @key }}" value="{{ @item }}">
              <option value="{{ @key }}" {{ (@GET.language ? @GET.language : @LANG) == @key ? 'selected' : '' }}>{{ @item }}</option>
            </repeat>
          </select>
        </form>
      </div>
    </div>
    <form action="{{ @URI }}" method="POST">
      <div class="row">
        <div class="col s12">
          <div id="strings">
            <table class="bordered highlight responsive-table">
              <thead>
                <tr>
                  <th>{{ @text.string_original }}</th>
                  <th>{{ @text.string_override }}</th>
                </tr>
              </thead>
              <tbody>
                <repeat group="{{ @vars.strings }}" key="{{ @code }}" value="{{ @string }}">
                  <check if="{{ is_array(@string) }}">
                    <true>
                      <repeat group="{{ @string }}" key="{{ @s_code }}" value="{{ @s_string }}">
                        <tr>
                          <td>{{ @s_string }}</td>
                          <td>
                            <div class="input-field">
                              <input type="text" name="{{ str_replace('.','#',@code) }}[{{ str_replace('.','#',@s_code) }}]" value="{{ isset(@vars.overrides[@code][@s_code]) ? @vars.overrides[@code][@s_code] : @vars.strings[@code][@s_code] }}">
                            </div>
                          </td>
                        </tr>
                      </repeat>
                    </true>
                    <false>
                      <tr>
                        <td>{{ @string }}</td>
                        <td>
                          <div class="input-field">
                            <input type="text" name="{{ str_replace('.','#',@code) }}" value="{{ isset(@vars.overrides[@code]) ? @vars.overrides[@code] : @vars.strings[@code] }}">
                          </div>
                        </td>
                      </tr>
                    </false>
                  </check>
                </repeat>
              </tbody>
            </table>
          </div>
        </div>
      </div>
      <div class="row">
        <div class="col s12">
          <button class="waves-effect waves-light btn-large" type="submit">{{ @text.save }}</button>
        </div>
      </div>
    </form>
  </section>
  <!--END Strings-->
</section>