<script type="text/javascript">
// debug level
var DEBUG = parseInt('{{ @DEBUG }}', 10);
// site wide language and locale, e.g. en_US, fr_FR
var LOCALE = '{{ str_replace('-','_',@LANG) }}';
// language code, i.e. en, fr, de etc
var LANGSHORT = '{{ @LANGSHORT }}';
// Base path
var BASE_PATH = '{{ @BASE }}';
// currency path
var PATH = '{{ @PATH }}';
var API = {
  coinsData:       '{{ @BASE }}/api/coins', // API Endpoint to get coins market data
  history:         '{{ @BASE }}/api/history', // API Endpoint to get historical market data
  coinsSearch:     '{{ @BASE }}/api/search/coins', // API Endpoint to search coins
  addFavorite:     '{{ @BASE }}/api/favorite/add',
  removeFavorite:  '{{ @BASE }}/api/favorite/remove'
};
// RSS feed URL
var NEWS_FEED_URL = '{{ @SITE.RSS_URL }}';
// How fast news headlines are typed (note: the smaller the value is the faster text is typed)
var NEWS_TYPE_SPEED = parseInt('{{ @SITE.RSS_SPEED }}',10);
// Delay in seconds before erasing a news headline
var NEWS_DELAY_BEFORE_ERASING = parseInt('{{ @SITE.RSS_DELAY }}',10);
// Number of coins to display by default
var FACEBOOK_APP_ID = '{{ @SOCIAL.FACEBOOK_APP_ID }}';

var CRYPTOCOMPARE_API_KEY = '{{ @API.CRYPTOCOMPARE_API_KEY }}';

var COINS_LIMIT = parseInt('{{ @SITE.COINS_LIMIT }}',10);
var COINS_SORT = '{{ @GET.sort ? @GET.sort : @SITE.COINS_SORT }}';
var COINS_DIR = '{{ @GET.dir ? @GET.dir : @SITE.COINS_DIR }}';
var COINS_FEATURED = '{{ @GET.featured ? @GET.featured : 0 }}';
var COINS_FIELDS = '{{ implode(",",(array)@SITE.COINS_FIELDS) }}'.split(',');
var COINS_REALTIME_FEED = ('{{ @SITE.COINS_REALTIME_FEED }}' == 'on');
var COIN_PAGE_SLUG = '{{ @BASE }}{{ "coin","symbol= " | alias }}';
var FEATURED_COINS = '{{ implode(",",(array)@SITE.FEATURED_COINS) }}'.split(',');
var DISPLAY_CURRENCY = JSON.parse('{{ json_encode(@vars.display_currency) }}');
var THOUSANDS_SEPARATOR = '{{ \Inc\Helper::thousandsSeparator() }}';
var DECIMAL_POINT = '{{ \Inc\Helper::decimalPoint() }}';
var TRADES_LIMIT = parseInt('{{ @SITE.TRADES_LIMIT }}',10);
var REQUIRE_COOKIE_ACCEPTANCE = ('{{ @SITE.REQUIRE_COOKIE_ACCEPTANCE }}' == 'on');
var COLORS = {
  amber:  '#ffc107',
  blue:   '#2196F3',
  brown:  '#8d6e63',
  green:  '#4CAF50',
  grey:   '#9e9e9e',
  indigo: '#5c6bc0',
  lime:   '#cddc39',
  orange: '#ff9800',
  pink:   '#e91e63',
  purple: '#ab47bc',
  red:    '#F44336',
  teal:   '#009688'
};
var COLOR = '{{ @SITE.COLOR }}';
var COLOR_CODE = typeof COLORS['{{ @SITE.COLOR }}'] != 'undefined' ? COLORS['{{ @SITE.COLOR }}'] : '#2196F3';
// chart settings
var CHART = {
  typeCoin:         '{{ @CHART.TYPE_COIN }}',
  typeVolume:       '{{ @CHART.TYPE_VOLUME }}',
  periods:          '{{ implode(",",(array)@CHART.PERIODS) }}'.split(','),
  defaultPeriod:    '{{ @CHART.DEFAULT_PERIOD }}',
  usePrefixes:      ('{{ @CHART.SHORT_NUMBER_FORMAT }}' == 'on'),
  scrollbarEnabled: ('{{ @CHART.SCROLLBAR_ENABLED }}' == 'on')
};
// translations
var TEXT = {
  cryptocurrency:     '{{ htmlentities(@text.cryptocurrency, ENT_QUOTES) }}',
  price:              '{{ htmlentities(@text.price, ENT_QUOTES) }}',
  open:               '{{ htmlentities(@text.open, ENT_QUOTES) }}',
  low:                '{{ htmlentities(@text.low, ENT_QUOTES) }}',
  high:               '{{ htmlentities(@text.high, ENT_QUOTES) }}',
  close:              '{{ htmlentities(@text.close, ENT_QUOTES) }}',
  market_cap:         '{{ htmlentities(@text.market_cap, ENT_QUOTES) }}',
  volume_ccy:         '{{ htmlentities(@text.volume_ccy, ENT_QUOTES) }}',
  supply:             '{{ htmlentities(@text.supply, ENT_QUOTES) }}',
  volume:             '{{ htmlentities(@text.volume, ENT_QUOTES) }}',
  change:             '{{ htmlentities(@text.change, ENT_QUOTES) }}',
  change_pct:         '{{ htmlentities(@text.change_pct, ENT_QUOTES) }}',
  last_updated:       '{{ htmlentities(@text.last_updated, ENT_QUOTES) }}',
  featured:           '{{ htmlentities(@text.featured, ENT_QUOTES) }}',
  intraday_quotes:    '{{ htmlentities(@text.intraday_quotes, ENT_QUOTES) }}',
  trade_buy:          '{{ htmlentities(@text.trade_buy, ENT_QUOTES) }}',
  trade_sell:         '{{ htmlentities(@text.trade_sell, ENT_QUOTES) }}',
  trade_unknown:      '{{ htmlentities(@text.trade_unknown, ENT_QUOTES) }}',
  id:                 '{{ htmlentities(@text.id, ENT_QUOTES) }}',
  type:               '{{ htmlentities(@text.type, ENT_QUOTES) }}',
  market:             '{{ htmlentities(@text.market, ENT_QUOTES) }}',
  quantity:           '{{ htmlentities(@text.quantity, ENT_QUOTES) }}',
  total:              '{{ htmlentities(@text.total, ENT_QUOTES) }}',
  no_subs:            '{{ htmlentities(@text.no_subs, ENT_QUOTES) }}',
  '1d': '{{ @text.1d }}',
  '1w': '{{ @text.1w }}',
  '2w': '{{ @text.2w }}',
  '1m': '{{ @text.1m }}',
  '3m': '{{ @text.3m }}',
  '6m': '{{ @text.6m }}',
  '1y': '{{ @text.1y }}',
  '2y': '{{ @text.2y }}',
  '5y': '{{ @text.5y }}',
  ytd: '{{ @text.ytd }}',
  all: '{{ @text.all }}',
  compare: '{{ htmlentities(@text.compare, ENT_QUOTES) }}',
  readMore: '{{ htmlentities(@text.read_more, ENT_QUOTES) }}',
  select2: {
    noResults: function() {
      return '{{ htmlentities(@text.search_not_found, ENT_QUOTES) }}';
    },
    errorLoading: function() {
      return '{{ htmlentities(@text.search_error, ENT_QUOTES) }}';
    },
    inputTooShort: function() {
      return '{{ htmlentities(@text.search_short, ENT_QUOTES) }}';
    }
  },
  amCharts: {
    'menu.label.save.image':        '{{ htmlentities(@text.download_as, ENT_QUOTES) }}',
    'menu.label.draw':              '{{ htmlentities(@text.annotate, ENT_QUOTES) }}',
    'menu.label.save.data':         '{{ htmlentities(@text.save_as, ENT_QUOTES) }}',
    'menu.label.print':             '{{ htmlentities(@text.print, ENT_QUOTES) }}',
    'menu.label.draw.add':          '{{ htmlentities(@text.add, ENT_QUOTES) }}',
    'menu.label.draw.shapes':       '{{ htmlentities(@text.shape, ENT_QUOTES) }}',
    'menu.label.draw.colors':       '{{ htmlentities(@text.color2, ENT_QUOTES) }}',
    'menu.label.draw.widths':       '{{ htmlentities(@text.size, ENT_QUOTES) }}',
    'menu.label.draw.opacities':    '{{ htmlentities(@text.opacity, ENT_QUOTES) }}',
    'menu.label.draw.text':         '{{ htmlentities(@text.text, ENT_QUOTES) }}',
    'menu.label.draw.modes':        '{{ htmlentities(@text.mode, ENT_QUOTES) }}',
    'menu.label.draw.modes.pencil': '{{ htmlentities(@text.pencil, ENT_QUOTES) }}',
    'menu.label.draw.modes.line':   '{{ htmlentities(@text.line, ENT_QUOTES) }}',
    'menu.label.draw.modes.arrow':  '{{ htmlentities(@text.arrow, ENT_QUOTES) }}',
    'menu.label.undo':              '{{ htmlentities(@text.undo, ENT_QUOTES) }}',
    'menu.label.redo':              '{{ htmlentities(@text.redo, ENT_QUOTES) }}',
    'menu.label.cancel':            '{{ htmlentities(@text.cancel, ENT_QUOTES) }}',
    'menu.label.draw.change':       '{{ htmlentities(@text.change2, ENT_QUOTES) }}',
    'label.saved.from':             '{{ htmlentities(@text.saved_from, ENT_QUOTES) }}'
  },
  datatables: {
    sSearch:            '',
    sSearchPlaceholder: '{{ htmlentities(@text.search, ENT_QUOTES) }}',
    sInfo:              '{{ htmlentities(@text.info_all, ENT_QUOTES) }}',
    sInfoFiltered:      '{{ htmlentities(@text.info_filtered, ENT_QUOTES) }}',
    sEmptyTable:        '{{ htmlentities(@text.empty_table, ENT_QUOTES) }}',
    oPaginate: {
      sFirst:     '{{ htmlentities(@text.first, ENT_QUOTES) }}',
      sLast:      '{{ htmlentities(@text.last, ENT_QUOTES) }}',
      sNext:      '{{ htmlentities(@text.next, ENT_QUOTES) }}',
      sPrevious:  '{{ htmlentities(@text.previous, ENT_QUOTES) }}'
    }
  }
};

<check if="{{ @ALIAS == 'coin' }}">
  var COIN_LINK = '{{ @PARAMS.symbol }}';
  var COIN_SYMBOL = '{{ @vars.coin.symbol }}';
  var COIN_LOGO = '{{ @vars.coin.logo }}';
  var COIN_TRADE_SUBS = '{{ @vars.coin.subs }}' ? '{{ @vars.coin.subs }}'.split(',') : [];
  var COIN_PRICE = '{{ @vars.coin.price }}';
  var COIN_WS_DISABLED = ('{{ @vars.coin.ws_disabled }}' == 1);
</check>
<check if="{{ @ALIAS == 'calculator' }}">
  var COINS_QUOTES = JSON.parse('{{ json_encode(@vars.coins_quotes, JSON_NUMERIC_CHECK) }}');
</check>
<check if="{{ @ALIAS == 'widget' }}">
  var COIN = JSON.parse('{{ json_encode(@vars.coin) }}');
</check>
</script>
