<!--Footer-->
<footer class="page-footer">
  <div class="container section">
    <div class="row">
      <div class="col s12 m12 l6">
        <h5>
          <img src="{{ file_exists('assets/images/logo-udf.png') ? 'assets/images/logo-udf.png' : 'assets/images/logo.png' }}">
          <span>{{ @site.name }}</span>
        </h5>
        <p>
          {{ @site.description }}
        </p>
        <check if="{{ @vars.donation_coins }}">
          <button id="donate-button" class="btn {{ @SITE.COLOR }} waves-effect waves-light modal-trigger" href="#donation-modal">{{ @text.donate }}</button>
        </check>
      </div>
      <div class="col s12 m6 l3">
        <h5><span>{{ @text.top_risers }}</span></h5>
        <ul>
          <repeat group="{{ @vars.risers }}" value="{{ @coin }}">
            <li><a href="{{ @BASE }}{{ 'coin','symbol='.@coin.coin_page_key | alias }}">{{ @coin.name }}</a><span class="right change change-up">{{ @coin.change_pct }}</span></li>
          </repeat>
        </ul>
        <a href="{{ @BASE }}{{ 'risers' | alias }}" class="right"><i class="material-icons">keyboard_arrow_right</i>{{ @text.view_all }}</a>
      </div>
      <div class="col s12 m6 l3">
        <h5><span>{{ @text.top_fallers }}</span></h5>
        <ul>
          <repeat group="{{ @vars.fallers }}" value="{{ @coin }}">
            <li><a href="{{ @BASE }}{{ 'coin','symbol='.@coin.coin_page_key | alias }}">{{ @coin.name }}</a><span class="right change change-down">{{ @coin.change_pct }}</span></li>
          </repeat>
        </ul>
        <a href="{{ @BASE }}{{ 'fallers' | alias }}" class="right"><i class="material-icons">keyboard_arrow_right</i>{{ @text.view_all }}</a>
      </div>
    </div>
  </div>
  <div class="container">
    <div class="divider"></div>
  </div>
  <div class="footer-copyright">
    <div class="container section">
      <div class="row">
        <div class="col s12 m6">
          <a href="{{ @BASE }}/page/faq">{{ @text.faq_header }}</a>
        </div>
        <div class="col s12 m6 right-align">
          {{ @text.built_using }} <a href="https://www.cryptocompare.com/api/" rel="nofollow" target="_blank">CryptoCompare free API</a>
        </div>
      </div>
    </div>
  </div>
</footer>
<!--END Footer-->

<!--Donate modal-->
<check if="{{ @vars.donation_coins }}">
  <div id="donation-modal" class="modal modal-fixed-footer">
    <div class="modal-content">
      <h4>{{ @text.donate }}</h4>
      <p>{{ @text.donate_text }}</p>
      <repeat group="{{ @vars.donation_coins }}" key="{{ @symbol }}" value="{{ @coin }}">
        <h5><img src="{{ @BASE }}/assets/images/coins/thumb30/{{ @coin.logo }}">{{ @coin.name }} [{{ @symbol }}]</h5>
        <div class="row valign-wrapper">
          <div class="input-field col s10 l11">
            <input type="text" value="{{ @coin.address }}" readonly="readonly">
          </div>
          <div class="col s2 l1">
            <button class="{{ @SITE.COLOR }} btn-floating waves-effect waves-light btn copy-address-button"><i class="material-icons left">content_copy</i></button>
          </div>
        </div>
      </repeat>
    </div>
    <div class="modal-footer">
      <button class="{{ @SITE.COLOR }} modal-action modal-close waves-effect waves-light btn">{{ @text.close }}</button>
    </div>
  </div>
</check>
<!--END Donate modal-->