<div id="fb-root"></div>
<header>
	<div class="primary-background">
		<div class="darken-background">
			<div class="row container">
				<div id="total-cryptocurrencies" class="col s12 m4 left-align">
					<b>{{ @vars.coins_overall_stats.total_coins }}</b> {{ @text.cryptocurrencies }}
				</div>
				<div class="col s12 m4 center-align">
					{{ @text.total_market_cap }} <b>{{ @vars.display_currency.code }}{{ @vars.coins_overall_stats.total_market_cap }}</b>
				</div>
				<div id="total-volume" class="col s12 m4 right-align">
					{{ @text.total_volume }} <b>{{ @vars.display_currency.code }}{{ @vars.coins_overall_stats.total_volume }}</b>
				</div>
			</div>
		</div>
	</div>
	<!--Navigation-->
	<nav class="primary-background" role="navigation">
		<div class="nav-wrapper container">
			<!--Desktop-->
			<a href="{{ @BASE }}" class="brand-logo">
				<img src="{{ file_exists('assets/images/logo-udf.png') ? 'assets/images/logo-udf.png' : 'assets/images/logo.png' }}">
				{{ @site.name }}
			</a>
			<ul class="right">
				<li><select id="search-coins"></select></li>
				<li><a id="search-coins-button"><i class="material-icons">search</i></a></li>
				<li id="currency-dropdown">
					<select id="currency-select">
						<repeat group="{{ @vars.currencies_list }}" key="{{ @symbol }}" value="{{ @ccy }}">
							<option value="{{ @symbol }}"  {{ @vars.display_currency.symbol==@symbol ? 'selected':'' }} >{{ @symbol }} &mdash; {{ @ccy['name'] }}</option>
						</repeat>
					</select>
				</li>
				<li id="language-dropdown">
					<select id="language-select">
						<repeat group="{{ @vars.languages_list }}" key="{{ @language }}" value="{{ @language_name }}">
							<set country="{{ strtolower(substr(@language, -2)) }}" />
							<option value="{{ @language }}" data-flag="assets/images/flags/{{ @country }}.png" {{ strtolower(substr(@vars.display_language, -2))==@country ? 'selected':'' }} >{{ $language_name }}</option>
						</repeat>
					</select>
				</li>
				<li id="day-night-change-header"><a href="#" id="theme-change-button" ><i class="material-icons">brightness_medium</i></a></li>
				<li><a href="#" id="menu-button" data-activates="side-menu"><i class="material-icons">menu</i></a></li>
			</ul>
		</div>
	</nav>

	<!-- admin menu dropdown -->
	<check if="{{ @USER.admin }}">
		<ul id="admin-menu" class="dropdown-content">
			<li><a href="{{ @BASE }}{{ 'backend_settings' | alias }}" class="language-code"><i class="material-icons">settings</i> {{ @text.settings }}</a></li>
		</ul>
	</check>
	<check if="{{ file_exists('app/templates/public/menu-udf.php') }}">
		<true>
			<include href="{{ 'public/menu-udf.php' }}" />
		</true>
		<false>
			<include href="{{ 'public/menu.php' }}" />
		</false>
	</check>
</header>