<!DOCTYPE html>
<html lang="{{ @LANGSHORT }}">
<include href="public/head.php" />
<body class="page-{{ @ALIAS }} {{ @vars.page_theme}}">
  <check if="{{ file_exists('app/templates/public/header-udf.php') }}">
    <true>
      <include href="public/header-udf.php" />
    </true>
    <false>
      <include href="public/header.php" />
    </false>
  </check>
  <include if="{{ file_exists('app/templates/public/blocks/before-content.php') }}" href="public/blocks/before-content.php" />
  <include if="{{ @ADSENSE.CLIENT_ID && @ADSENSE.SLOT_ID1 }}" href="public/adsense.php" with="slot_id={{ @ADSENSE.SLOT_ID1 }}"/>
  <check if="{{ @ALIAS == 'page' }}">
    <true>
      <set template="{{ @PARAMS['slug'] }}" />
    </true>
    <false>
      <set template="{{ @ALIAS }}" />
    </false>
  </check>
  <check if="{{ file_exists('app/templates/public/' . @template . '-udf.php') }}">
    <true>
      <include href="{{ 'public/' . @template . '-udf.php' }}" />
    </true>
    <false>
      <include href="{{ 'public/' . @template . '.php' }}" />
    </false>
  </check>
  <include if="{{ @ADSENSE.CLIENT_ID && @ADSENSE.SLOT_ID2 }}" href="public/adsense.php" with="slot_id={{ @ADSENSE.SLOT_ID2 }}"/>
  <include if="{{ file_exists('app/templates/public/blocks/after-content.php') }}" href="public/blocks/after-content.php" />
  <check if="{{ file_exists('app/templates/public/footer-udf.php') }}">
    <true>
      <include href="public/footer-udf.php" />
    </true>
    <false>
      <include href="public/footer.php" />
    </false>
  </check>
  <check if="{{ file_exists('app/templates/public/cookie-policy-udf.php') }}">
    <true>
      <include href="public/cookie-policy-udf.php" />
    </true>
    <false>
      <include href="public/cookie-policy.php" />
    </false>
  </check>
  <include href="public/scripts.php" />
</body>
</html>