<!--Main content-->
<section id="content" class="container">
  <header>
    <div class="row">
      <div class="col s12">
        <h1 class="primary-text">
          {{ @text.top_risers }}
        </h1>
        <div class="divider"></div>
      </div>
    </div>
  </header>
  <!--Coins table-->
  <section id="coins-table">
    <div class="row">
      <div class="col s12">
        <table id="coins-list" class="bordered highlight vertical-responsive-table">
          <thead>
            <tr>
              <th>{{ @text.cryptocurrency }}</th>
              <repeat group="{{ @SITE.RISERS_FALLERS_FIELDS }}" value="{{ @field }}">
                <th class="right-align">
                  <check if="{{ @field=='change_pct' }}">
                    <i class="material-icons">arrow_drop_down</i>
                  </check>
                 {{ @text[@field] }}
                </th>
              </repeat>
            </tr>
          </thead>
          <tbody>
          <repeat group="{{ @vars.coins }}" key="{{ @i }}" value="{{ @coin }}">
            <tr class="{{ @coin.featured ? 'featured' : '' }} {{ @coin.ws_disabled==1 ? 'ws-disabled' : '' }} coin-row coin-row-{{ @coin.symbol }}" data-symbol="{{ @coin.symbol }}">
              <td data-title="{{ @text.cryptocurrency }}">
                <span class="coin-number">{{ @i+1 }}</span>
                <a href="{{ @BASE }}{{ 'coin','symbol='.@coin.coin_page_key | alias }}">
                  <img src="assets/images/coins/thumb30/{{ @coin.logo }}" alt="{{ @coin.name }}" title="{{ @coin.name }}">
                </a>
                <span><a href="{{ @BASE }}{{ 'coin','symbol='.@coin.coin_page_key | alias }}">{{ @coin.name }}</a></span>
                <check if="{{ @coin.featured }}">
                  <span data-badge-caption="{{ @text.featured }}" class="new {{ @SITE.COLOR }} badge"></span>
                </check>
              </td>
              <repeat group="{{ @SITE.RISERS_FALLERS_FIELDS }}" value="{{ @field }}">
                <check if="{{ in_array(@field, ['price','open','low','high','market_cap','volume_ccy','total_volume_ccy']) }}">
                  <td class="right-align" data-title="{{ @text[@field] }}"><sup>{{ @vars.display_currency.code }}</sup><span class="coin-{{ @field }}-value">{{ @coin[@field] }}</span></td>
                </check>
                <check if="{{ in_array(@field, ['supply','volume','total_volume']) }}">
                  <td class="right-align" data-title="{{ @text[@field] }}"><span class="coin-{{ @field }}-value">{{ @coin[@field] }}</span> {{ @coin.symbol }}</td>
                </check>
                <check if="{{ in_array(@field, ['change','change_pct']) }}">
                  <td class="right-align" data-title="{{ @text[@field] }}">
                    <span class="coin-{{ @field }}-value {{ @coin.raw_data[@field] > 0 ? 'change-up' : (@coin.raw_data[@field] < 0 ? 'change-down' : '') }}">{{ @coin[@field] }}</span>
                </td>
                </check>
                <check if="{{ @field == 'intraday_quotes' }}">
                  <td class="performance-sparkline right-align" data-title="{{ @text[@field] }}">
                    <check if="{{ @coin.intraday_quotes && isset(@coin.intraday_quotes['p']) }}">
                      <span values="{{ implode(',',@coin.intraday_quotes['p']) }}"></span>
                    </check>
                  </td>
                </check>
                <check if="{{ @field == 'last_updated' }}">
                  <td class="right-align" data-title="{{ @text[@field] }}">{{ @coin.last_updated }}</td>
                </check>
              </repeat>
            </tr>
          </repeat>
          </tbody>
        </table>
      </div>
    </div>
  </section>
  <!--END Coins table-->
</section>
<!--END Main content-->