<?php
namespace View;

use Inc\Helper;

abstract class Base {
  // an array to store arbitrary model data, which can be accessible in templates
  public $data = array();

  /**
   * Format view data before rendering it (passing it to a template)
   */
  public function format() {
    $formatter = new Formatter();
    foreach ($this->data as $key => &$item) {
      $key = Helper::snakeToCamelCase($key);
      if (method_exists($formatter, 'formatter' . $key))
        $item = call_user_func([$formatter, 'formatter' . $key], $item);
    }
  }
  /**
   * @return mixed
   * Render view
   */
  abstract public function render();
}