"use strict";
$(document).ready(function() {
  var queryString = location.search.substring(1);
  var query = queryString ? JSON.parse('{"' + decodeURI(queryString).replace(/"/g, '\\"').replace(/&/g, '","').replace(/=/g,'":"') + '"}') : {};

  getNews();

  $('.performance-sparkline span').displaySparklineCharts();

  $('#switch-featured').on('change', function () {
    query.featured = $(this).is(':checked') ? 1 : 0;
    setTimeout(function () {
      window.location.href = '?' + $.param(query);
    }, 150);
  });

  function getNews() {
    if (NEWS_FEED_URL) {
      var url = 'https://query.yahooapis.com/v1/public/yql?q=' + encodeURIComponent('SELECT * FROM feed WHERE url="' + NEWS_FEED_URL + '"') + '&format=json&env=store%3A%2F%2Fdatatables.org%2Falltableswithkeys';
      $.ajax({
        url: url,
        dataType: 'json',
        async: true,
        cache: false,
        success: displayNews,
        error: handleAjaxError
      });
    }
  }

  function displayNews(response) {
    var newsHtml = [];
    if (typeof response.query != 'undefined' && typeof response.query.count != 'undefined' && response.query.count>0) {
      var n = response.query.results.item.length;
      for (var i=0; i<n; i++) {
        var news = response.query.results.item[i];
        newsHtml.push(news.title + ' <a href="'+(news.link?news.link:(news.origLink?news.origLink:'#'))+'" target="_blank">'+TEXT.readMore+'</a>' + (i < n-1 ? '^'+(parseInt(NEWS_DELAY_BEFORE_ERASING,10)*1000) : ''));
      }
      var typed = new Typed('#news-ticker-typed', {strings: newsHtml, typeSpeed: NEWS_TYPE_SPEED, loop: true, contentType: 'html'});
    }
  }
});