"use strict";
$(document).ready(function () {
  var coinLastPrice = COIN.price || 0;
  var $coinPrice = $('.data-field-price');
  var $coinAbsChange = $('.data-field-abs-change');
  var $coinPctChange = $('.data-field-pct-change');

  initRealTimeFeed();

  function initRealTimeFeed() {
    if (COIN.symbol && COIN.currency_rate && COIN.ws_disabled==0) {
      var feed = new RealTimeDataFeed({
        subs: ['5~CCCAGG~' + COIN.symbol + '~USD'],
        onAggQuote: function (quote) {
          log(quote);
          if (typeof quote.PRICE != 'undefined') {
            var currentPrice = quote.PRICE * COIN.currency_rate;
            var lastTickChange = currentPrice - coinLastPrice;
            $coinPrice.text(formatDecimal(currentPrice));
            coinLastPrice = currentPrice;
          }
          if (typeof quote.OPEN24HOUR != 'undefined' && coinLastPrice > 0) {
            var openPrice = quote.OPEN24HOUR * COIN.currency_rate;
            var absChange = coinLastPrice - openPrice;
            var pctChange = coinLastPrice / openPrice - 1;

            $coinAbsChange.text(formatDecimal(absChange));
            $coinPctChange.text(formatPercentage(pctChange));

            if (absChange > 0 && $coinAbsChange.hasClass('change-down'))
              $coinAbsChange.removeClass('change-down').addClass('change-up');
            if (absChange < 0 && $coinAbsChange.hasClass('change-up'))
              $coinAbsChange.removeClass('change-up').addClass('change-down');
            if (pctChange > 0 && $coinPctChange.hasClass('change-down'))
              $coinPctChange.removeClass('change-down').addClass('change-up');
            if (pctChange < 0 && $coinPctChange.hasClass('change-up'))
              $coinPctChange.removeClass('change-up').addClass('change-down');
          }
        }
      });
    }
  }
});