<?php

use Phinx\Seed\AbstractSeed;


class CoinSeeder extends AbstractSeed {

  /**
   * Run Method.
   *
   * Write your database seeder using this method.
   *
   * More information on writing seeders is available here:
   * http://docs.phinx.org/en/latest/seeding.html
   */
  public function run() {
    $this->execute('SET autocommit = 0');
    $this->execute('SET character_set_results = "utf8", character_set_client = "utf8", character_set_connection = "utf8", character_set_database = "utf8", character_set_server = "utf8"');

    // drop unique index on symbol column, so mutual symbol updates (e.g.  BBT-->BBT* and BBT* --> BBT) do not fail
    try {
      $this->execute('DROP INDEX uq_coin_symbol ON coin');
    // if index didn't exist and exception is raised just ignore it
    } catch (\PDOException $e) {
      error_log(sprintf('INDEX uq_coin_symbol does not exist: %s', $e->getMessage()));
    }
    $coins = json_decode(file_get_contents('db/seeds/coins.json'), JSON_OBJECT_AS_ARRAY);
    $databaseCoins = [];
    // retrieve id and symbol of all coins saved to database
    foreach ($this->fetchAll('SELECT id, symbol FROM coin') as $coin) {
      $databaseCoins[$coin['id']] = $coin['symbol'];
    };

    // loop through each coin in local data file
    foreach ($coins as $id => $coin) {
      try {
        // if such coin is NOT in the database yet try to add it
        if (!array_key_exists($id, $databaseCoins)) {
          $coinTable = $this->table('coin'); //important to keep it in the loop
          $coinTable->insert($coin)->save();
        // if it's already in the database then update some columns
        } else {
          $this->execute(sprintf('UPDATE coin SET symbol = "%s", name = "%s", logo = "%s", subs = "%s", twitter = "%s" WHERE id = %d', $coin['symbol'], $coin['name'], $coin['logo'], $coin['subs'], (isset($coin['twitter']) ? $coin['twitter'] : ''), $id));
        }
      } catch (\PDOException $e) {
        error_log(sprintf('Coin %d: %s', $id, $e->getMessage()));
      }
    }

    // check if some coins need to be deleted from the database (if they are not present in the local file)
    foreach ($databaseCoins as $coinId => $databaseCoin) {
      if (!isset($coins[$coinId]))
        $this->execute('DELETE FROM coin WHERE id = ' . $coinId);
    }
    $this->execute('COMMIT');
    $this->execute('ALTER TABLE coin ADD UNIQUE INDEX uq_coin_symbol (symbol ASC)');
  }
}
