<?php

use Phinx\Seed\AbstractSeed;

class CurrencySeeder extends AbstractSeed {

  /**
   * Run Method.
   *
   * Write your database seeder using this method.
   *
   * More information on writing seeders is available here:
   * http://docs.phinx.org/en/latest/seeding.html
   */
  public function run() {
    $inputData = json_decode(file_get_contents('db/seeds/currencies.json'));
    $data = [];

    foreach ($inputData as $symbol => $currency) {
      $data[] = [
        'symbol'      => $symbol,
        'name'        => $currency->name,
        'code'        => $currency->symbol,
        'code_native' => $currency->symbol_native,
        'rate'        => 1
      ];
    }

    if (!empty($data)) {
      $coinTable = $this->table('currency');
      $coinTable->insert($data)->save();
    }
  }
}
